from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class KnowledgeableWorseAndWorse(Player):
    """
    This strategy is based on 'Worse And Worse' but will defect with probability
    of 'current turn / total no. of turns'.

    Names:
        - Knowledgeable Worse and Worse: Original name by Adam Pohl
    """

    name = "Knowledgeable Worse and Worse"
    classifier = {
        "memory_depth": float("inf"),
        "stochastic": True,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        current_round = len(self.history) + 1
        expected_length = self.match_attributes["length"]
        probability = 1 - current_round / expected_length
        return self._random.random_choice(probability)